package easik.sketch.util.Export.Components;

import java.util.ArrayList;
import java.util.HashMap;

import easik.sketch.util.Export.ExportConstants;

/**
 * Class to store attribute information.  Should only be used for exportation to a database.  
 * Does not provide functionality for graphical display.
 * 
 * @author Vera Ranieri 2006
 * @since 2006-05-18 Vera Ranieri
 * @version 2006-06-30 Vera Ranieri
 */
public class ExportAttribute {
		/**
		 * The name of this attribute
		 */
		private String _name;
		/**
		 * The type of this attribute
		 */
		private String _type;
		/**
		 * The HashMap of types, indexed by the platform
		 */
		private HashMap _types;
		
		/**
		 * Constructor.  Attributes are not allowed to have whitespace in the name.  Any contained 
		 * whitespaces are replaced with an underscore.
		 * 
		 * @param name The name of the attribute
		 * @param tempType The data type of the attribute
		 * @param types HashMap of all types, indexed by the key <it>type</it>
		 * @since 2006-05-18, Vera Ranieri
		 */
		public ExportAttribute(String name, String tempType, HashMap types){
			
			_name= name.trim().replace(' ', '_');
			_type = tempType;
			_types = types;
		}
		
		/**
		 * Getter method for the name of the attribute
		 * @return The name of the attribute
		 * @since 2006-05-18, Vera Ranieri
		 */
		public String getName(){
			return _name;
		}
		
		/**
		 * Getter method for the data type of the attribute
		 * 
		 * @return The data type of the attribute
		 * @since 2006-05-18, Vera Ranieri
		 */
		public String getType(){
			return (String)_types.get(_type);
		}
		
		/**
		 * Formats the Attribute string for SQL.  Accepts a table as a parameter.  The attributes of this table are
		 * then determined and the attribute string is created.  This attribute string does not contain any foreign key
		 * references or unique or primary key references.
		 * 
		 * @param t The table for which attributes need to be determined.
		 * @return The attribute string formatted for SQL derived from table t
		 * @since 2006-06-14, Vera Ranieri
		 */
		public static String getAttributeString(ExportTable t){
			ArrayList arr = t.getAttributes();
			int size = arr.size();
			//The attribute string
			String attrStr = t.getName() + ExportConstants.ID + ExportConstants.ID_TYPE + ExportConstants.AUTO_INCREMENT+", \n";
		
			ExportAttribute attr;
			
			// Get all the columns formed by attributes
			for(int i = 0; i<size; i++){
				attr = (ExportAttribute)arr.get(i);
				
				//Add attribute name and description to attribute string
				attrStr += attr.getName()+ " " + attr.getType() + ", \n";
			}
			
			//Get all the columns formed by foreign keys
			ArrayList edges = t.getEdges();
			size = edges.size();
			ExportEdge e;
			
			for(int i = 0; i< size; i++){
				e = (ExportEdge)edges.get(i);
				
				attrStr += e.getTarget() + ExportConstants.ID + ExportConstants.ID_TYPE + ExportConstants.NOT_NULL 
							+ ", \n";
			}
			return attrStr;
		}
	
}
